#delim;
clear;

use cexdata;

label variable wmdlogc0100  	"CEX, wgt. avg. of log cons growth, all consumer units";
label variable wmdlogc95100 	"CEX, wgt. avg. of log cons growth, top 5% of consumer units by consumption in previous interview";
label variable wc0100       	"CEX, wgt. avg. of consumption in this interview, all consumer units";
label variable wclag0100    	"CEX, wgt. avg. of consumption in previous interview (for same cu's as wc0100), all consumer units";
label variable wc95100      	"CEX, wgt. avg. of consumption in this interview, top 5% of consumer units by consumption in previous interview";
label variable wclag95100   	"CEX, wgt. avg. of consumption in previous interview (for same cu's as wc95100), top 5% of consumer units by consumption in previous interview";
label variable iwc95100     	"CEX, wgt. avg. of consumption in this, top 5% of consumer units by consumption in current interview";
label variable persinc 		"NIPA Table 2.6, line 1, personal income";
label variable perstransfers	"NIPA Table 2.6, line 14, personal current transfer receipts";
label variable perssocsec	"NIPA Table 2.6, line 20, contributions for government social insurance";
label variable disppersinc	"NIPA Table 2.6, line 22, disposable personal income";
label variable pop		"NIPA Table 2.6, line 33, population";
label variable pcend		"NIPA Table 2.8.5, line 4";
label variable pcesv		"NIPA Table 2.8.5, line 5";
label variable cpiurs		"BLS, CPI-U-RS";


* AGGREGATE CONSUMPTION AND INCOME;
* ================================;

so year month;
ge realc=(pcend+pcesv)/cpiurs;
ge gc=ln((realc+realc[_n-1]+realc[_n-2])/(realc[_n-3]+realc[_n-4]+realc[_n-5]))-ln(pop/pop[_n-3]);
ge Dc4=(gc+gc[_n-3]+gc[_n-6]+gc[_n-9]);

* y before transfers and soc sec contrib and taxes;
ge yprepreex=(persinc-perstransfers+perssocsec)/(cpiurs*(pop/1000000));
* y after transfers, but before soc sec contrib and taxes;
ge yprepostex=(persinc+perssocsec)/(cpiurs*(pop/1000000));
* y after transfer, after soc sec contrib and taxes;
ge ypostpostex=(disppersinc)/(cpiurs*(pop/1000000));

ge Dyprepreex=ln((yprepreex+yprepreex[_n-1]+yprepreex[_n-2])/(yprepreex[_n-3]+yprepreex[_n-4]+yprepreex[_n-5]));
ge Dyprepostex=ln((yprepostex+yprepostex[_n-1]+yprepostex[_n-2])/(yprepostex[_n-3]+yprepostex[_n-4]+yprepostex[_n-5]));
ge Dypostpostex=ln((ypostpostex+ypostpostex[_n-1]+ypostpostex[_n-2])/(ypostpostex[_n-3]+ypostpostex[_n-4]+ypostpostex[_n-5]));

ge Dyprepreex4=Dyprepreex+Dyprepreex[_n-3]+Dyprepreex[_n-6]+Dyprepreex[_n-9];
ge Dyprepostex4=Dyprepostex+Dyprepostex[_n-3]+Dyprepostex[_n-6]+Dyprepostex[_n-9];
ge Dypostpostex4=Dypostpostex+Dypostpostex[_n-3]+Dypostpostex[_n-6]+Dypostpostex[_n-9];



* CEX CONSUMPTION;
* ===============;

for any 0100 95100: egen mX=mean(wmdlogcX), by(year);
for any 0100 95100: egen mwX=mean(wcX), by(year);
for any 0100 95100: egen mwlagX=mean(wclagX), by(year);
for any 95100: egen miwX=mean(iwcX), by(year);

for any 0100 95100: replace wmdlogcX=mX if wmdlogcX==. & month==3 & inlist(year,1986,1996,2005)==1;
for any 0100 95100: replace wcX=mwX if wcX==. & month==3 & inlist(year,1986,1996,2005)==1;
for any 0100 95100: replace wclagX=mwlagX if wclagX==. & month==3 & inlist(year,1986,1996,2005)==1;
for any 95100: replace iwcX=miwX if iwcX==. & month==3 & inlist(year,1986,1996,2005)==1;

for any 0100 95100: ge DcX4=(wmdlogcX+wmdlogcX[_n-3]+wmdlogcX[_n-6]+wmdlogcX[_n-9]);
for any 0100 95100: ge DcX1alts=ln(wcX/wclagX); *same people;
for any 0100 95100: ge DcX4alts=(DcX1alts+DcX1alts[_n-3]+DcX1alts[_n-6]+DcX1alts[_n-9]);


* TABLE 6;
* =======;

for any 0100 95100: ge rndssX=wcX/wc0100;
tabstat rndss0100 rndss95100, stat(mean);

so n;
xi: newey Dc01004 Dyprepreex4 i.month , lag(11); so n;
xi: newey Dc951004 Dyprepreex4 i.month , lag(11); so n;

xi: newey Dc01004 Dypostpostex4 i.month , lag(11); so n;
xi: newey Dc951004 Dypostpostex4 i.month , lag(11); so n;

xi: newey Dc01004 Dc4 i.month , lag(11); so n;
xi: newey Dc951004 Dc4 i.month , lag(11); so n;

xi: newey Dc01004alts Dc01004alts i.month , lag(11); so n;
xi: newey Dc951004alts Dc01004alts i.month , lag(11); so n;

for any  0100  95100: ge dcX=(wcX-wclagX)+(wcX[_n-3]-wclagX[_n-3])+(wcX[_n-6]-wclagX[_n-6])+(wcX[_n-9]-wclagX[_n-9]);
ge fd0100=dc0100*(1)/wclag0100[_n-9];
ge fd95100=dc95100*(0.05)/wclag0100[_n-9];
xi: newey fd0100 fd0100 i.month, lag(11); so n;
xi: newey fd95100 fd0100 i.month, lag(11);


* FIGURE 1;
* ========;

so year;

ge iwc0100=wc0100;
for any 0100 95100: replace iwcX=. if year==2005 & month<=2; * Use interviews from March 2005 on, i.e. consumption from January 2005 on;
for any 0100 95100: egen miwcX=mean(iwcX), by(year);
for any 0100 95100: ge baseX=miwcX if year==2005 & month==3;
for any 0100 95100: egen mbaseX=max(baseX);
for any 0100 95100: ge lngcX=ln(miwcX)-ln(mbaseX);
drop base* mbase*;
label variable lngc0100 "CEX, All households";
label variable lngc95100 "CEX, Top 5%";
label variable year " ";
li year lngc0100 lngc95100 if year~=year[_n-1] & year>=2005;
scatter lngc0100  lngc95100 year if year>=2005, c(l l l) saving(figic, replace) t1("Non-durables and some services") symbol(c T);
